# Отчёт по инвариантной самостоятельной работе
**Тема:** Создание диаграммы Ганта и анализ рисков для образовательного IT-проекта

---

## 1. Введение

В рамках инвариантной самостоятельной работы требуется спланировать проектную деятельность по разработке компонента образовательной среды и проанализировать потенциальные риски.

**Выбранный проект:** Разработка веб-приложения **"Виртуальный симулятор химических реакций"** для учащихся 8-9 классов средней школы. Симулятор позволит безопасно проводить виртуальные химические эксперименты, визуализировать процессы на молекулярном уровне и автоматически проверять составленные уравнения реакций.

**Цель работы:** 
1. Спроектировать временной план работ с помощью диаграммы Ганта.
2. Провести качественный анализ потенциальных рисков проекта.
3. Оформить результаты в виде отчёта-репозитория на GitHub.

---

## 2. Описание проекта

### 2.1. Краткое описание
Компонент представляет собой одностраничное веб-приложение (SPA), которое:
*   Содержит интерактивную периодическую таблицу для выбора реагентов.
*   Визуализирует процесс смешивания веществ в пробирке.
*   Показывает анимацию молекулярного взаимодействия (упрощённую).
*   Проверяет правильность составленного уравнения реакции.
*   Выдаёт теоретическую справку по проведённому эксперименту.
*   Интегрируется в существующий школьный портал через iframe или API.

**Целевая аудитория:** Учащиеся 8-9 классов, учителя химии.

### 2.2. Ключевые задачи проекта
1.  Анализ требований и прототипирование.
2.  Разработка клиентской части (фронтенд).
3.  Разработка серверной логики для расчётов (бэкенд).
4.  Создание базы данных химических соединений и реакций.
5.  Комплексное тестирование.
6.  Развёртывание и документация.

---

## 3. Диаграмма Ганта

Диаграмма отражает план проекта с **01.10.2025** по **20.12.2025** (12 недель).

```mermaid
gantt
    title Диаграмма Ганта: Виртуальный симулятор химических реакций
    dateFormat  YYYY-MM-DD
    axisFormat %d/%m
    section Анализ и проектирование
    Сбор требований у учителей           :crit, a1, 2025-10-01, 5d
    Анализ предметной области (химия)    :a2, after a1, 4d
    Проектирование UI/UX (Figma)         :a3, after a2, 6d
    Техническое задание (ТЗ)             :milestone, m1, 2025-10-16, 0d

    section Разработка Frontend
    Настройка окружения (React + Three.js) :b1, 2025-10-17, 3d
    Верстка базовых компонентов          :b2, after b1, 7d
    Логика интерактивной таблицы         :crit, b3, after b2, 6d
    Анимация "пробирки" и реакций        :b4, after b3, 8d

    section Разработка Backend & База данных
    Проектирование БД (PostgreSQL)       :c1, 2025-10-21, 4d
    Разработка API (Node.js/Express)     :crit, c2, after c1, 10d
    Наполнение БД данными (соединения)   :c3, after c2, 5d
    Алгоритм проверки уравнений          :crit, c4, after c3, 7d

    section Интеграция и тестирование
    Связка Frontend и API                :crit, d1, 2025-11-18, 5d
    Модульное тестирование               :d2, after d1, 4d
    Пользовательское тестирование (учителя) :d3, after d2, 7d
    Исправление ошибок и доработка       :d4, after d3, 6d

    section Завершение
    Написание документации               :e1, 2025-12-09, 4d
    Развёртывание на тестовый сервер     :e2, after e1, 3d
    Финальная презентация продукта       :milestone, m2, 2025-12-16, 0d
    Сдача проекта                        :milestone, m3, 2025-12-20, 0d